﻿using System.Collections.Generic;

namespace Microscopic_Traffic_Simulator___Model.CellularTopologyObjects.CellWalkers
{
    /// <summary>
    /// Cell walker in backward direction.
    /// </summary>
    class BackwardCellWalker : CellWalker
    {
        /// <summary>
        /// Initialize cell walker in backward direction.
        /// </summary>
        /// <param name="cell">Cell from the walk starts.</param>
        internal BackwardCellWalker(Cell cell) : base(cell) { }

        /// <summary>
        /// Method for obtaining walked cells in backward direction.
        /// </summary>
        /// <returns>Walked cells.</returns>
        internal override IEnumerable<Cell> GetNext()
        {
            if (cell != null)
            {
                yield return cell;
                while (cell.PreviousCell != null)
                {
                    cell = cell.PreviousCell;
                    yield return cell;
                }
            }
        }
    }
}
